<?php
include 'koneksi.php';

if (isset($_POST['edit'])) {
    $id_obat = mysqli_real_escape_string($conn, $_POST['id_obat']);
    $kode_obat = mysqli_real_escape_string($conn, $_POST['kode_obat']);
    $nama_obat = mysqli_real_escape_string($conn, $_POST['nama_obat']);
    $bentuk = mysqli_real_escape_string($conn, $_POST['bentuk']);
    $satuan = mysqli_real_escape_string($conn, $_POST['satuan']);
    $harga_beli = mysqli_real_escape_string($conn, $_POST['harga_beli']);
    $harga_jual = mysqli_real_escape_string($conn, $_POST['harga_jual']);
    $stok_minimum = mysqli_real_escape_string($conn, $_POST['stok_minimum']);
    $stok_maksimum = mysqli_real_escape_string($conn, $_POST['stok_maksimum']);
    $lead_time_hari = mysqli_real_escape_string($conn, $_POST['lead_time_hari']);
    $tgl_kadaluarsa = mysqli_real_escape_string($conn, $_POST['tgl_kadaluarsa']);

    // Validasi input
    $cek_kode = "SELECT * FROM obat WHERE kode_obat = '$kode_obat' AND id_obat != '$id_obat'";
    $result_kode = mysqli_query($conn, $cek_kode);

    if (mysqli_num_rows($result_kode) > 0) {
        echo "<script>alert('❌ Kode obat sudah digunakan oleh obat lain!'); window.location='obat.php';</script>";
        exit;
    } elseif ($harga_jual < $harga_beli) {
        echo "<script>alert('❌ Harga jual tidak boleh lebih kecil dari harga beli!'); window.location='obat.php';</script>";
        exit;
    } elseif ($stok_minimum >= $stok_maksimum) {
        echo "<script>alert('❌ Stok minimum harus lebih kecil dari stok maksimum!'); window.location='obat.php';</script>";
        exit;
    } else {
        // Ambil data lama untuk perbandingan
        $query_old = "SELECT nama_obat, harga_beli, harga_jual FROM obat WHERE id_obat = '$id_obat'";
        $result_old = mysqli_query($conn, $query_old);
        $old_data = mysqli_fetch_assoc($result_old);
        
        // Update hanya data identitas obat, tidak mengubah stok dan barcode
        $query = "UPDATE obat SET 
                  kode_obat = '$kode_obat',
                  nama_obat = '$nama_obat',
                  bentuk = '$bentuk',
                  satuan = '$satuan',
                  harga_beli = '$harga_beli',
                  harga_jual = '$harga_jual',
                  stok_minimum = '$stok_minimum',
                  stok_maksimum = '$stok_maksimum',
                  lead_time_hari = '$lead_time_hari',
                  tgl_kadaluarsa = '$tgl_kadaluarsa'
                  WHERE id_obat = '$id_obat'";
        
        if (mysqli_query($conn, $query)) {
            // Hitung total stok untuk info
            $query_stok = "SELECT COALESCE(SUM(jumlah), 0) as total_stok FROM stok WHERE id_obat = '$id_obat'";
            $result_stok = mysqli_query($conn, $query_stok);
            $stok_data = mysqli_fetch_assoc($result_stok);
            $total_stok = $stok_data['total_stok'];
            
            // Buat pesan perubahan
            $perubahan = array();
            if ($old_data['nama_obat'] != $nama_obat) {
                $perubahan[] = "Nama: '{$old_data['nama_obat']}' → '$nama_obat'";
            }
            if ($old_data['harga_beli'] != $harga_beli) {
                $perubahan[] = "Harga Beli: Rp " . number_format($old_data['harga_beli'], 0, ',', '.') . " → Rp " . number_format($harga_beli, 0, ',', '.');
            }
            if ($old_data['harga_jual'] != $harga_jual) {
                $perubahan[] = "Harga Jual: Rp " . number_format($old_data['harga_jual'], 0, ',', '.') . " → Rp " . number_format($harga_jual, 0, ',', '.');
            }
            
            $pesan_perubahan = count($perubahan) > 0 ? "\\n\\n📝 Perubahan:\\n" . implode("\\n", $perubahan) : "";
            
            echo "<script>
                alert('✓ Data obat berhasil diperbarui!$pesan_perubahan\\n\\n📦 Total stok saat ini: $total_stok unit\\n\\nℹ️ Catatan:\\n- Barcode tidak berubah\\n- Stok tidak terpengaruh\\n- Kelola stok melalui menu Stok Gudang');
                window.location='obat.php';
            </script>";
        } else {
            echo "<script>alert('❌ Gagal memperbarui data obat: " . mysqli_error($conn) . "'); window.location='obat.php';</script>";
        }
    }
}
?>